this.name        = "ups_sun"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Solar missions of UPS Courier"; 
this.version     = "1.4.2"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.71") > 0)
    {
        // Oolite version is older than 1.71.
        log("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Sun missions are disabled.")
        delete this.missionScreenEnded
        delete this.missionChoiceWasReset
        delete this.shipExitedWitchspace
        delete this.shipLaunchedFromStation
        delete this.shipWillLaunchFromStation
        delete this.shipDockedWithStation
        delete this.missionChoiceWasReset
        delete this.playerEnteredNewGalaxy
    }
    this.cleanup=this.CLEANUP;
}

this.reset = function()
{
    this.cleanup=this.CLEANUP;
}

this.shipWillLaunchFromStation = function(station)
{
    this.cleanup();
}

this.DISABLE=function(name)
{
    if (!this.old) this.old={};
    if (!name || name=='') return;
    if (!this.old[name])
            this.old[name]=this[name];
    delete this[name];
}

this.ENABLE=function(name)
{
    if (!name || name==''||!this.old) return;
    this[name]=this.old[name];
}
this.CLEANUP = function()
{ //can't check missionVariables inside startUp or reset
    if (!missionVariables.ups_sunbase) // No solar missions active
    {
        //no need to run any of these!
        this.DISABLE("shipDockedWithStation");	
        this.DISABLE("shipLaunchedFromStation");
        this.DISABLE("shipExitedWitchspace");
        this.DISABLE("missionScreenEnded");
        this.DISABLE("missionChoiceWasReset");
    } 
    else
    {
        if (this.old)
        {
            this.ENABLE("shipDockedWithStation");	
            this.ENABLE("shipLaunchedFromStation");
            this.ENABLE("shipExitedWitchspace");
            this.ENABLE("missionScreenEnded");		
            this.ENABLE("missionChoiceWasReset");		
            log("script.ups_sun", "Re-enabling ups_sun script.");
        }
    }
    this.cleanup=function(){}; // run just once per script startup/reset
}

this.shipDockedWithStation = function()
{
// missionVariables.ups_sunbase is set to "YES" by a mission in ups_docs.
    if (missionVariables.ups_sunbase == "YES" && player.docked)
    {
        this.ups_missionOffers()
    }
}

this.ups_missionOffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return;
    if (player.dockedStation.isMainStation)
    {
        if (missionVariables.ups_sun == "YES")
        {
            if (system.techLevel > 10 && !mission.choice)
            {
                missionVariables.ups_stationparts = expandDescription("[ups_stationparts]")
                mission.runMissionScreen("ups_sun_offer", "UPS.png", "ups_sun_accepted_yesno")
                missionVariables.offering ="UPS_SOLAR1"
            }
        }
        if (missionVariables.ups_sun == "RESCUEOFFER")
        {
            if (system.government > 1 && !mission.choice)
            { 
                mission.runMissionScreen("ups_sun_offer3", "solar.png", "ups_sun_accepted3_yesno")
                missionVariables.offering = "UPS_SOLAR3" 
                missionVariables.ups_stimerstart = clock.days
            }
        }
        if (missionVariables.ups_sun == "EXPLOSION")
        {
            if (!mission.choice)
            { 
                missionVariables.ups_s2award = missionVariables.ups_s2award // removing tailing zero's from string
                if (missionVariables.ups_s2count == "0") { mission.runMissionScreen("ups_sun_unloading3a", "UPS.png")}
                else {mission.runMissionScreen("ups_sun_unloading3", "UPS.png")}
                missionVariables.ups_sunvisits++
                mission.setInstructionsKey() 
                mission.unmarkSystem(missionVariables.ups_splanet)
                player.credits += missionVariables.ups_s2award 
                missionVariables.ups_sun = "FINISHED" 
                this.sunReset(); return
            }
        }
        if (missionVariables.ups_sun == "RESCUE")
        {
            missionVariables.ups_difference = clock.days - missionVariables.ups_stimerstart
            // missionVariables.ups_difference shows up in a message
            if (missionVariables.ups_difference > 20 && !mission.choice)
            {
                missionVariables.ups_sun = "FINISHED" 
                mission.runMissionScreen("ups_sun_explosion", "solar.png")
                mission.setInstructionsKey() 
                mission.unmarkSystem(missionVariables.ups_splanet)
                this.sunReset()
            }
        }
        return;
    }
    if (player.dockedStation.shipDescription == "Sun Research Station Alpha")
    {
        if (missionVariables.ups_sun == "SMALL_DELIVERY")
        {
                mission.runMissionScreen("ups_sun_unloading", "UPS.png")
                missionVariables.ups_sunvisits++
                player.credits += 250
                mission.setInstructionsKey() 
                missionVariables.ups_sun = "NOT_NOW" 
                missionVariables.ups_stationparts = null
                mission.unmarkSystem(missionVariables.ups_splanet)
                this.increaseReputation()
                return;
        }
        if (missionVariables.ups_scount && missionVariables.ups_scount > 0 && !missionVariables.ups_blackbox && !mission.choice)
        {
                mission.runMissionScreen("ups_sun_offer2", "UPS.png", "ups_sun_accepted2_yesno")
                missionVariables.ups_blackbox = "OFFERED"
        } 
        if (missionVariables.ups_blackbox && missionVariables.ups_blackbox == "SEARCHING" && !mission.choice)
        {
                missionVariables.ups_s2award = missionVariables.ups_s2award // remove trailing zero's
                if (missionVariables.ups_s2count == "0")
                {
                    mission.runMissionScreen("ups_sun_unloading2a", "UPS.png")
                    missionVariables.ups_blackbox = null
                }
                else
                { 
                    mission.runMissionScreen("ups_sun_unloading2", "UPS.png")
                    missionVariables.ups_blackbox = "FINISHED"
                } 
                player.credits += s2award
                mission.setInstructionsKey() 
                missionVariables.ups_s2count = null
                missionVariables.ups_s2award = null
        }
        if (missionVariables.ups_sun == "RESCUE" && !missionVariables.ups_rescue)
        {
                mission.runMissionScreen("ups_sun_rescue", "solar.png")
                mission.setInstructionsKey("ups_sun_small4") 
                missionVariables.ups_rescue = "YES", 
                missionVariables.ups_s2count = "10", 
                missionVariables.ups_s2award = "1500", 
                missionVariables.ups_sun = "EXPLOSION"
        }
    }
}

this.ups_choiceEvaluation = function()
{
    if (missionVariables.offering == "UPS_SOLAR1")
    {
        if (mission.choice == "YESSun")
        {
            mission.markSystem(missionVariables.ups_splanet) 
            mission.setInstructionsKey("ups_sun_small") 
            missionVariables.ups_sun = "SMALL_DELIVERY" 
            missionVariables.offering = null
            mission.choice = null
        }
        else
        {
            if (mission.choice == "NOSun")
            { 
                missionVariables.ups_sun = "NOT_NOW" 
                missionVariables.offering = null
                missionVariables.ups_stationparts = null
                mission.choice = null
                if(Math.random()<0.5) this.decreaseReputation()
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
    if (missionVariables.offering == "UPS_SOLAR3")
    {
        if (mission.choice == "YESSun")
        { 
            mission.markSystem(missionVariables.ups_splanet) 
            mission.setInstructionsKey("ups_sun_small3") 
            missionVariables.ups_sun = "RESCUE" 
            missionVariables.offering = null
            mission.choice = null 
        }
        else
        {
            if (mission.choice == "NOSun")
            { 
                missionVariables.ups_sun = "RESCUE" 
                missionVariables.offering = null
                mission.choice = null
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
    if (missionVariables.ups_blackbox == "OFFERED")
    {
        if (mission.choice == "YESSun")
        {
                missionVariables.ups_blackbox = "YES", 
                mission.setInstructionsKey("ups_blackbox_small") 
                mission.choice = null
        }
        else
        {
                if (mission.choice == "NOSun")
                {
                    missionVariables.ups_blackbox = "NO"
                    mission.choice = null
                } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        } 
    }
}

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    if (missionVariables.ups_sunbase == "YES") 
    {
        if(mission.choice) this.ups_choiceEvaluation()
        this.ups_missionOffers()
    }
}

this.missionChoiceWasReset = function()
{
    if(!player.docked) return;
    if (missionVariables.ups_sunbase == "YES") 
    {
        this.ups_missionOffers()
    }
}

this.setUpShips_ups_sun = function()
{
        if (missionVariables.ups_splanet == system.ID)
        {
            if(missionVariables.ups_splanet == missionVariables.ups_splanetname) {missionVariables.ups_splanetname = expandDescription("[%H]")} // temporary bugfix code
            if (system.countShipsWithRole("ups_dependance") == 0 && !missionVariables.ups_rescue)
            {
                    if (missionVariables.ups_sun == "RESCUE")
                    {
                        system.legacy_addShipsAt("ups_dependance", 1, "sps", 0, 0, 1.5)
                        missionVariables.ups_s2count = "0"
                    }
                    else
                    {
                        system.legacy_addShipsAt("ups_dependance", 1, "sps", 0, 0, 2.6) 
                        system.legacy_addShipsAt("ups-sunskim", 3, "sps", 0, 0, 2.6) 
                        system.legacy_addShipsAt("ups_shuttle", 8, "sps", 0, 0, 2.6)
                    }
                    system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, 0.2) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, 0.4) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, 0.6) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, 0.8) 
                    system.legacy_addShipsAt("ups-sun-police", 4, "spu", 0, 0, 0.5) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, 0.2) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, 0.4) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, 0.6) 
                    system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, 0.8)
                    if(worldScripts.transportSchedule  || worldScripts.transportschedule !== undefined)  // has Transports.OXP installed
                    {
                        system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
                        system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
                        system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
                    }
            }
        }
}

this.shipExitedWitchspace = function()
{
    if (system.isInterstellarSpace) return;
    if (missionVariables.ups_sunbase == "YES") 
    {
        this.setUpShips_ups_sun();
        if (missionVariables.ups_blackbox == "FINISHED")
        {
            if (missionVariables.ups_sunvisits && missionVariables.ups_sunvisits > 3  && Math.random() < 0.3)
            {// make sure missionVariables.ups_sunvisits is defined before checking a value.
                missionVariables.ups_blackbox = null
            }
        }
        else
        {
            if (missionVariables.ups_blackbox == "SEARCHING") {mission.setInstructionsKey()}
            missionVariables.ups_blackbox = null
            missionVariables.ups_scount = null
        }
        if (missionVariables.ups_sun == "NOT_NOW" && Math.random() < 0.1) {missionVariables.ups_sun = "NO"}
        if (missionVariables.ups_sun == "NO")
        {
            if (system.techLevel > 10 && Math.random() < 0.2){missionVariables.ups_sun = "YES"}
            else
            {
                if (system.government > 1 && Math.random() < 0.1 && missionVariables.ups_sunvisits && missionVariables.ups_sunvisits > 4)
                {missionVariables.ups_sun = "RESCUEOFFER"}
            }    
        }
    }
}

this.sunReset = function()
{
    mission.setInstructionsKey() 
    mission.unmarkSystem(missionVariables.ups_splanet)
    missionVariables.ups_splanet = null 
    missionVariables.ups_splanetname = null
    missionVariables.ups_sun = null
    missionVariables.ups_scount = null
    missionVariables.ups_scount = null 
    missionVariables.ups_s2award = null 
    missionVariables.ups_s2count = null
    missionVariables.ups_blackbox = null
    missionVariables.ups_sunvisits = null
    missionVariables.ups_sunbase = null
    missionVariables.ups_stimerstart = null 
    missionVariables.ups_stationparts = null
    missionVariables.ups_rescue = null
} 

this.playerEnteredNewGalaxy = function()
{
    if (missionVariables.ups_sun) this.sunReset()
}

this.shipLaunchedFromStation = function()
{
    if (missionVariables.ups_sunbase == "YES") 
    {
        if(!missionVariables.ups_splanet) {missionVariables.ups_splanet = missionVariables.ups_splanetname} // temporary bugfix code
        this.setUpShips_ups_sun();
        if (missionVariables.ups_blackbox == "YES")
        {
                missionVariables.ups_blackbox = "SEARCHING" 
                missionVariables.ups_s2count = "0" 
                missionVariables.ups_s2award = "0"
                let scount =  missionVariables.ups_scount
                system.legacy_addShipsAt("UPS-black_box", scount, "sps", 0, 0, 1.1) 
                missionVariables.ups_scount = null
        }
    }
}

// temp fix for 1.71/1.72 compatibility.
this.increaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("increaseContractReputation")
        else player.increaseContractReputation()
}

this.decreaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("decreaseContractReputation")
        else player.decreaseContractReputation()
}